#version 120










precision highp float;



uniform float testvalue;
uniform float shininess;

const int maxnumalights=8;
uniform float widths[maxnumalights];
uniform float heights[maxnumalights];
uniform vec3 pnormals[maxnumalights];
uniform vec3 right[maxnumalights];





#define MAX_LIGHTS 8

#define NUMLIGHTS 4
float actualnumlights;
#define NUMLIGHTSINTEXTURE 4

#define TEXTURESIZE 1024.0f
float SHADOW=0.05f;
#define SHADOWORTHO -0.3f















uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];

uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];


uniform float lightsAmbientr[MAX_LIGHTS];
uniform float lightsAmbientg[MAX_LIGHTS];
uniform float lightsAmbientb[MAX_LIGHTS];

uniform float lightsDiffuser[MAX_LIGHTS];
uniform float lightsDiffuseg[MAX_LIGHTS];
uniform float lightsDiffuseb[MAX_LIGHTS];

uniform float lightsSpecularr[MAX_LIGHTS];
uniform float lightsSpecularg[MAX_LIGHTS];
uniform float lightsSpecularb[MAX_LIGHTS];















const int method = 1;





in vec3 alightVec[MAX_LIGHTS];
in vec3 aeyeVec[MAX_LIGHTS];
in vec2 texCoord;

in vec4 vpos; 
uniform int renderingmirror;
uniform vec4 clipeq;

in float ShadowAngle[NUMLIGHTS];
in vec4 ShadowCoord[NUMLIGHTS];
uniform float anglebias;

uniform vec4 LightsPos[NUMLIGHTS];
uniform vec4 Lights[NUMLIGHTS];
uniform float lightsOn[NUMLIGHTS];
in vec4 vN_;

in vec3 v;
in vec3 N;
in vec3 T;
in vec3 B;
in float screendepth;
uniform vec3 camPos;


uniform vec4 glColor;
uniform vec4 flash;

uniform float bias;




/*
uniform sampler2D colorMap;
uniform sampler2D normalMap;

uniform sampler2D specularMap;
uniform sampler2D shadowMap;
*/

uniform float shadowmapmix[30];
uniform sampler2D colorMap0;
uniform sampler2D colorMap1;
uniform sampler2D colorMap2;
uniform sampler2D colorMap3;

#define colorMap colorMap0
#define shadowMap colorMap0
#define specularMap colorMap0

bool inshadow;






vec3 CalcBumpedNormal()
{
    vec3 Normal = N;
    vec3 Tangent = T;
    Tangent = normalize(Tangent - dot(Tangent, Normal) * Normal);
    
    vec3 Bitangent = B;
    vec3 BumpMapNormal = vec3(0,1,0);//texture2D(normalMap, texCoord).xyz;
    BumpMapNormal = 2.0 * BumpMapNormal - vec3(1.0, 1.0, 1.0);
    vec3 NewNormal;
    mat3 TBN = mat3(Tangent, Bitangent, Normal);
    NewNormal = TBN * BumpMapNormal;
    NewNormal = normalize(NewNormal);
    return NewNormal;
}




vec3 projectOnPlane(in vec3 p, in vec3 pc, in vec3 pn)
{
    float distance = dot(pn, p-pc);
    return p - distance*pn;
}
int sideOfPlane(in vec3 p, in vec3 pc, in vec3 pn){
   if (dot(p-pc,pn)>=0.0) return 1; else return 0;
}
vec3 linePlaneIntersect(in vec3 lp, in vec3 lv, in vec3 pc, in vec3 pn){
   return lp+lv*(dot(pn,pc-lp)/dot(pn,lv));
}

float calculateAttenuation(in int i, in float dist)
{
    
    
    return clamp(1.0 - lightsinvRadius[i] * sqrt(dist), 0.0, 1.0);
}





void main (void)
{

    vec3 lightVec;
    vec3 eyeVec;
    vec4 accvDiffuse = vec4(0.0);
    vec4 accvSpecular = vec4(0.0);
    float distSqr;
    vec3 lVec;
    vec3 vVec;
    float att;
    vec4 base;
    vec4 vAmbient;
    vec3 bump;
    float diffuse;
    vec4 vDiffuse;
    vec4 vSpecular;
    float specular;
    vec3 nrmltexture;

    vec3 V=v;
    vec3 N_=CalcBumpedNormal();

    /*
    actualnumlights=0.0; for (int i=0;i<NUMLIGHTS;i++) if (lightsOn[i]>0.0) actualnumlights+=1.0;
    SHADOW*=NUMLIGHTS-actualnumlights+1.0;
    if (actualnumlights==1.0) SHADOW=0.6;
    */

    vec4 base0;
    vec4 base1;
    vec4 base2;
    vec4 base3;

    base1 = texture2D(colorMap1, texCoord)*
    (vec4(shadowmapmix[2*3+0],shadowmapmix[2*3+1],shadowmapmix[2*3+2],1.0)
    )/1.0;

    base2 = texture2D(colorMap2, texCoord)*
    (
             vec4(shadowmapmix[1*3+0],shadowmapmix[1*3+1],shadowmapmix[1*3+2],1.0)+
             vec4(shadowmapmix[3*3+0],shadowmapmix[3*3+1],shadowmapmix[3*3+2],1.0)+
             vec4(shadowmapmix[5*3+0],shadowmapmix[5*3+1],shadowmapmix[5*3+2],1.0)+
             vec4(shadowmapmix[7*3+0],shadowmapmix[7*3+1],shadowmapmix[7*3+2],1.0)
    )/4.0;

    base3 = texture2D(colorMap3, texCoord)*
    (
             vec4(shadowmapmix[0*3+0],shadowmapmix[0*3+1],shadowmapmix[0*3+2],1.0)+
             vec4(shadowmapmix[4*3+0],shadowmapmix[4*3+1],shadowmapmix[4*3+2],1.0)+
             vec4(shadowmapmix[6*3+0],shadowmapmix[6*3+1],shadowmapmix[6*3+2],1.0)+
             vec4(shadowmapmix[8*3+0],shadowmapmix[8*3+1],shadowmapmix[8*3+2],1.0)
    )/4.0;

    base0 = texture2D(colorMap0, texCoord)*
    (vec4(shadowmapmix[9*3+0],shadowmapmix[9*3+1],shadowmapmix[9*3+2],1.0))/1.0;

    base = vec4(0.0);
    float v0=(base0.r+base0.g+base0.b)/3.0;
    float v1=(base1.r+base1.g+base1.b)/3.0;
    float v2=(base2.r+base2.g+base2.b)/3.0;
    float v3=(base3.r+base3.g+base3.b)/3.0;

    float v_=v0; if (v1>v_) v_=v1;if (v2>v_) v_=v2;if (v3>v_) v_=v3;

    /*
    float w0=shadowmapmix[0]+shadowmapmix[1]+shadowmapmix[2];
    float w1=shadowmapmix[3]+shadowmapmix[4]+shadowmapmix[5];
    float w2=shadowmapmix[6]+shadowmapmix[7]+shadowmapmix[8];
    float w3=shadowmapmix[9]+shadowmapmix[10]+shadowmapmix[11];
    float tw=(w0+w1+w2+w3)/3.0;
    */
    float w1=shadowmapmix[0*3+0]+shadowmapmix[0*3+1]+shadowmapmix[0*3+2];

    float w2=shadowmapmix[1*3+0]+shadowmapmix[1*3+1]+shadowmapmix[1*3+2]+
             shadowmapmix[3*3+0]+shadowmapmix[3*3+1]+shadowmapmix[3*3+2]+
             shadowmapmix[5*3+0]+shadowmapmix[5*3+1]+shadowmapmix[5*3+2]+
             shadowmapmix[7*3+0]+shadowmapmix[7*3+1]+shadowmapmix[7*3+2];
             w2/=4.0;

    float w3=shadowmapmix[2*3+0]+shadowmapmix[2*3+1]+shadowmapmix[2*3+2]+
             shadowmapmix[4*3+0]+shadowmapmix[4*3+1]+shadowmapmix[4*3+2]+
             shadowmapmix[6*3+0]+shadowmapmix[6*3+1]+shadowmapmix[6*3+2]+
             shadowmapmix[8*3+0]+shadowmapmix[8*3+1]+shadowmapmix[8*3+2];
             w3/=4.0;

    float w0=shadowmapmix[9*3+0]+shadowmapmix[9*3+1]+shadowmapmix[9*3+2];

    float tw=(w0+w1+w2+w3)/3.0;

    base=(base0+base1+base2+base3)/tw;

    float vbase = (base.r+base.g+base.b)/3.0;
    if (vbase<0.001) vbase=0.001;
    base *= v_;
    base /= vbase;
    base.a = 1.0;

    /*
    if (v0>base.r+base.g+base.b) base=base0;
    if (v1>base.r+base.g+base.b) base=base1;
    if (v2>base.r+base.g+base.b) base=base2;
    if (v3>base.r+base.g+base.b) base=base3;
    */

    /*
    base = vec4(1.0)-base;
    base *= glColor;
    base.a = base.r;
    base.rgb = vec3(0.0);
    */
    base *= glColor;
    float pow_=1.59;
    base.r = pow(base.r,pow_);
    base.g = pow(base.g,pow_);
    base.b = pow(base.b,pow_);
    /*
    float screendepth_=screendepth/50.0;
    float fog = screendepth_/16.5;//length(screenV);
    vec4 fogcolor=vec4(0.2,0.5,0.9,1.0);
    */
    //vec4 fragColor=mix(base,fogcolor,fog);
    vec4 fragColor=base;

    gl_FragColor = fragColor;

    return;
}
